package jadean.dean.java.resources;

import jadean.dean.java.JavaProject;
import jadean.dean.java.JavaResource;
import jadean.dean.java.constants.JavaProjectConstants;

public class JavaResourceFactory {
	private JavaProject p;
	
	public JavaResourceFactory(JavaProject p) {
		this.p = p;
	}
	
	public JavaResource classNameToResource(String className, JavaResourceContext context) {
		switch (this.p.getResourceType(className, context)) {
			case JavaProjectConstants.RESOURCE_TYPE_PROJECT_CLASS:
			case JavaProjectConstants.RESOURCE_TYPE_PROJECT_CLASS_INNER:
				return new JavaResourceProjectClass(className, context, p);
			case JavaProjectConstants.RESOURCE_TYPE_PROJECT_PACKAGE:
				return new JavaResourceProjectPackage(className, context, p);
			case JavaProjectConstants.RESOURCE_TYPE_REFERENCED_PACKAGE:
				return new JavaResourceReferencedPackage(className, context, p);
			case JavaProjectConstants.RESOURCE_TYPE_REFERENCED_PACKAGE_CLASS:
				return new JavaResourceReferencedClass(className, context, p);
			case JavaProjectConstants.RESOURCE_TYPE_CLASSPATH_PACKAGE:
				return new JavaResourceClasspathPackage(className, context);
			case JavaProjectConstants.RESOURCE_TYPE_CLASSPATH_PACKAGE_CLASS:
				return new JavaResourceClasspathClass(className, context);				
		}
		return new JavaResourceDefault("", null);
	}
}
